

/*=================================================================*/
/*============== WAVE 4===========*/
/*=================================================================*/

use "..\Dataset\ABIV_English.dta", clear

gen wave=4
gen weight=wt
rename country cty
gen country = cty

*democracy attitudes
recode q512 (0=1) (11/.=.)
recode q512leb (0=1) (11/.=.)
replace q512 = q512leb if country == 10
recode q5164 (1=4) (2=3) (3=2) (4=1) (5/.=.)
gen q5171 = .
gen q5172 = .
recode q6071 (5/.=.)


/*
1. Algeria*
5. Egypt*
8. Jordan*
10. Lebanon*
13. Morocco
15. Palestine*
21. Tunisia*
22. Yemen*
*/

keep if country==1 | country==5 | country==7 | country==8 | country==10 ///
		| country==15 | country==19 | country==21 | country==22
keep wave weight country q512 q5164 q5171 q5172 q6071

save "wave4.dta"



/*=================================================================*/
/*============== WAVE 3===========*/
/*=================================================================*/

use "..\Dataset\ABIII_English.dta", clear

gen wave=3
gen weight=wt
rename country cty
gen country = cty

*democracy attitudes
recode q512 (0=1) (11/.=.)
recode q5164 (1=4) (2=3) (3=2) (4=1) (5/.=.)
recode q5171 (1=4) (2=3) (3=2) (4=1) (5/.=.)
recode q5172 (5/.=.)
recode q6071 (5/.=.)

/*
1. Algeria*
5. Egypt*
7. Iraq*
8. Jordan*
9. Kuwait
10. Lebanon*
11. Libya
13. Morocco
15. Palestine*
19. Sudan*
21. Tunisia*
22. Yemen*
*/

keep if country==1 | country==5 | country==7 | country==8 | country==10 ///
		| country==15 | country==19 | country==21 | country==22
keep wave weight country q512 q5164 q5171 q5172 q6071


save "wave3.dta"


/*=================================================================*/
/*============== WAVE 2===========*/
/*=================================================================*/

use "..\Dataset\ABII_English.dta", clear


gen wave=2
gen weight=wt
rename country cty
gen country = cty

*democracy attitudes
recode q512 (11/.=.)
recode q5164 (1=4) (2=3) (3=2) (4=1) (5/.=.)
recode q5171 (1=4) (2=3) (3=2) (4=1) (5/.=.)
recode q5172 (5/.=.)
recode q6071 (5/.=.)

/*
1. Algeria*
5. Egypt*
7. Iraq*
8. Jordan*
10. Lebanon*
15. Palestine*
17. Saudi Arabia
19. Sudan*
21. Tunisia*
22. Yemen*
*/

keep if country==1 | country==5 | country==7 | country==8 | country==10 ///
		| country==15 | country==19 | country==21 | country==22
keep wave weight country q512 q5164 q5171 q5172 q6071


save "wave2.dta"



/*=================================================================*/
/*============== WAVE 1===========*/
/*=================================================================*/

use "..\Dataset\ABI_English.dta", clear


*democracy attitudes
gen q512 = q243
gen q5164 = q2324
gen q5171 = q2451 
gen q5172 = q2452 
gen q6071 = q5041 

recode q512 (11/.=.)
recode q5164 (1=4) (2=3) (3=2) (4=1) (5/.=.)
recode q5171 (1=4) (2=3) (3=2) (4=1) (5/.=.)
recode q5172 (5/.=.)
recode q6071 (5/.=.)


gen wave=1
gen weight=1
rename country cty
gen country = cty

/* WAVE 1:
1 = Jordan*
2 = Palestine*
3 = Algeria*
4 = Morocco
5 = Kuwait
6 = Lebanon*
7 = Yemen*
8 = Bahrain
*/

/* WAVE 2:
1. Algeria*
5. Egypt*
7. Iraq*
8. Jordan*
10. Lebanon*
15. Palestine*
17. Saudi Arabia
19. Sudan*
21. Tunisia*
22. Yemen*
*/


*recode countries
recode country (1=8) (2=15) (3=1) (4=.) (5=.) (6=10) (7=22) (8=.)
keep if country==1 | country==5 | country==7 | country==8 | country==10 ///
		| country==15 | country==19 | country==21 | country==22
keep wave weight country q512 q5164 q5171 q5172 q6071

save "wave1.dta"


/*=================================================================*/
/*============== COMBINE ===========*/
/*=================================================================*/

append using wave1.dta wave2.dta wave3.dta wave4.dta
_strip_labels *


gen countryname = " "
replace countryname = "Algeria" if country==1
replace countryname = "Egypt" if country==5
replace countryname = "Iraq" if country==7
replace countryname = "Jordan" if country==8
replace countryname = "Lebanon" if country==10
replace countryname = "Palestine" if country==15
replace countryname = "Sudan" if country==19
replace countryname = "Tunisia" if country==21
replace countryname = "Yemen" if country==22

gen countrywave =countryname+ " " +string(wave,"%2.0f")
gen countrywaveid = country*10+wave


recode q512 q5164 q5171 q5172 q6071 (0=.)

*make binary
recode q512 (1/5=0) (6/10=1)
recode q5164 (1/2=0) (3/4=1)
recode q5171 (1/2=0) (3/4=1)
recode q5172 (1/2=0) (3/4=1)
recode q6071 (1/2=0) (3/4=1)


gen id = _n

*Waves 1, 2, 3
drop id
drop if wave==4
gen id = _n
outsheet using "IRT123bin.csv", comma nolabel replace



erase "wave4.dta"
erase "wave3.dta"
erase "wave2.dta"
erase "wave1.dta"
